unit Plugin1;

interface

Function EnumSnoopServices
         (Var Info:PChar;Var Proc:Pointer;Var ScanCode:Integer;
          Var Modifier:Integer; Var Copy:LongBool;Var Paste:LongBool;
          Var lParam:Longint;Var Reserved:Pointer):LongBool;Export;stdcall;
{This is the STANDARD type of this procedure

  "Info" is some information about plugin
  "Proc" is an address of translation routine
  "ScanCode" is a key scan-code on which this Plug-in is to be activated
  "Modifier" is a key modifier (Alt,Shift,Control) for "ScanCode"
  "Copy" means that has the main program to copy the selected text to clipboard
         and to pass it to plug-in
  "Paste" means that has the main program move the translated text to clipboard
          and paste it then
  "lParam" is some number which the program is to pass to the translation
           service
  "Reserved" is some pointer for future use. Now it must be nil

  Result of this function must mean:
         True - there are more services in this plug-in
         False - there are no more services in this plug-in
}

implementation

Uses Windows;


Function SnoopTranslate(lParam,HOut:Integer;Var HIn:Integer):Longint;Stdcall;
{This is also a STANDARD, but indirectly.
      "lParam" is the same like in "EnumSnoopServices", but here it is passed
               from th program to plug-in. I hope you guess
      "HOut" is a memory handle retrieved from clipboard as a result of copy
             operation
      "HIn"  is a memory handle whish contains the translated text

      Result of this function must mean amount of translated letters
}
begin
HIn:=HOut;
Result:=0;
end;

Function EnumSnoopServices(Var Info:PChar;Var Proc:Pointer;Var ScanCode:Integer;Var Modifier:Integer;Var Copy:LongBool;Var Paste:LongBool;Var lParam:Longint;Var Reserved:Pointer):LongBool;Export;stdcall;
begin
   Result:=False; //only one service
   Info:=PChar('Plugin number 1');  //some info
   Proc:=@SnoopTranslate; //address of translation routine
   ScanCode:=VK_PAUSE;
   Modifier:=MOD_ALT or MOD_CONTROL; //plug-in is activated with Alt-Ctrl-Pause
   Copy:=LongBool(True); //Yes, I want some user text
   Paste:=LongBool(True); //Yes, user wants my done work
   lParam:=0; //params don't mean a thing
   Reserved:=nil; //must be nil
end;


initialization

finalization

end.


